﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Window.Sample4
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool EnableWindow(IntPtr hWnd, bool bEnable);

        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonEnable_Click(object sender, EventArgs e)
        {
            IntPtr hWnd = FindWindow("Notepad", null);
            if (hWnd != IntPtr.Zero)
                EnableWindow(hWnd, true);
        }

        private void buttonDisable_Click(object sender, EventArgs e)
        {
            IntPtr hWnd = FindWindow("Notepad", null);
            if (hWnd != IntPtr.Zero)
                EnableWindow(hWnd, false);
        }
    }
}